import os

from .utils import Datum, DatasetBase


template = ['a photo of a {}, a type of aircraft.']
# template = ['a bad photo of a {}, a type of aircraft.',
#     'a photo of many {}, a type of aircraft.',
#     'a sculpture of a {}, a type of aircraft.',
#     'a photo of the hard to see {}, a type of aircraft.',
#     'a low resolution photo of the {}, a type of aircraft.',
#     'a rendering of a {}, a type of aircraft.',
#     'graffiti of a {}, a type of aircraft.',
#     'a bad photo of the {}, a type of aircraft.',
#     'a cropped photo of the {}, a type of aircraft.',
#     'a tattoo of a {}, a type of aircraft.',
#     'the embroidered {}, a type of aircraft.',
#     'a photo of a hard to see {}, a type of aircraft.',
#     'a bright photo of a {}, a type of aircraft.',
#     'a photo of a clean {}, a type of aircraft.',
#     'a photo of a dirty {}, a type of aircraft.',
#     'a dark photo of the {}, a type of aircraft.',
#     'a drawing of a {}, a type of aircraft.',
#     'a photo of my {}, a type of aircraft.',
#     'the plastic {}, a type of aircraft.',
#     'a photo of the cool {}, a type of aircraft.',
#     'a close-up photo of a {}, a type of aircraft.',
#     'a black and white photo of the {}, a type of aircraft.',
#     'a painting of the {}, a type of aircraft.',
#     'a painting of a {}, a type of aircraft.',
#     'a pixelated photo of the {}, a type of aircraft.',
#     'a sculpture of the {}, a type of aircraft.',
#     'a bright photo of the {}, a type of aircraft.',
#     'a cropped photo of a {}, a type of aircraft.',
#     'a plastic {}, a type of aircraft.',
#     'a photo of the dirty {}, a type of aircraft.',
#     'a jpeg corrupted photo of a {}, a type of aircraft.',
#     'a blurry photo of the {}, a type of aircraft.',
#     'a photo of the {}, a type of aircraft.',
#     'a good photo of the {}, a type of aircraft.',
#     'a rendering of the {}, a type of aircraft.',
#     'a {} in a video game, a type of aircraft.',
#     'a photo of one {}, a type of aircraft.',
#     'a doodle of a {}, a type of aircraft.',
#     'a close-up photo of the {}, a type of aircraft.',
#     'a photo of a {}, a type of aircraft.',
#     'the origami {}, a type of aircraft.',
#     'the {} in a video game, a type of aircraft.',
#     'a sketch of a {}, a type of aircraft.',
#     'a doodle of the {}, a type of aircraft.',
#     'a origami {}, a type of aircraft.',
#     'a low resolution photo of a {}, a type of aircraft.',
#     'the toy {}, a type of aircraft.',
#     'a rendition of the {}, a type of aircraft.',
#     'a photo of the clean {}, a type of aircraft.',
#     'a photo of a large {}, a type of aircraft.',
#     'a rendition of a {}, a type of aircraft.',
#     'a photo of a nice {}, a type of aircraft.',
#     'a photo of a weird {}, a type of aircraft.',
#     'a blurry photo of a {}, a type of aircraft.',
#     'a cartoon {}, a type of aircraft.',
#     'art of a {}, a type of aircraft.',
#     'a sketch of the {}, a type of aircraft.',
#     'a embroidered {}, a type of aircraft.',
#     'a pixelated photo of a {}, a type of aircraft.',
#     'itap of the {}, a type of aircraft.',
#     'a jpeg corrupted photo of the {}, a type of aircraft.',
#     'a good photo of a {}, a type of aircraft.',
#     'a plushie {}, a type of aircraft.',
#     'a photo of the nice {}, a type of aircraft.',
#     'a photo of the small {}, a type of aircraft.',
#     'a photo of the weird {}, a type of aircraft.',
#     'the cartoon {}, a type of aircraft.',
#     'art of the {}, a type of aircraft.',
#     'a drawing of the {}, a type of aircraft.',
#     'a photo of the large {}, a type of aircraft.',
#     'a black and white photo of a {}, a type of aircraft.',
#     'the plushie {}, a type of aircraft.',
#     'a dark photo of a {}, a type of aircraft.',
#     'itap of a {}, a type of aircraft.',
#     'graffiti of the {}, a type of aircraft.',
#     'a toy {}, a type of aircraft.',
#     'itap of my {}, a type of aircraft.',
#     'a photo of a cool {}, a type of aircraft.',
#     'a photo of a small {}, a type of aircraft.',
#     'a tattoo of the {}, a type of aircraft.']
class FGVCAircraft(DatasetBase):

    dataset_dir = 'fgvc_aircraft'

    def __init__(self, root):
        
        self.dataset_dir = os.path.join(root, self.dataset_dir)
        self.image_dir = os.path.join(self.dataset_dir, 'images')

        self.template = template

        classnames = []
        with open(os.path.join(self.dataset_dir, 'variants.txt'), 'r') as f:
            lines = f.readlines()
            for line in lines:
                classnames.append(line.strip())
        cname2lab = {c: i for i, c in enumerate(classnames)}

        test = self.read_data(cname2lab, 'images_variant_test.txt')
        
        
        super().__init__(test=test)
    
    def read_data(self, cname2lab, split_file):
        filepath = os.path.join(self.dataset_dir, split_file)
        items = []
        
        with open(filepath, 'r') as f:
            lines = f.readlines()
            for line in lines:
                line = line.strip().split(' ')
                imname = line[0] + '.jpg'
                classname = ' '.join(line[1:])
                impath = os.path.join(self.image_dir, imname)
                label = cname2lab[classname]
                item = Datum(
                    impath=impath,
                    label=label,
                    classname=classname
                )
                items.append(item)
        
        return items